import React from 'react';
import Modal from '@material-ui/core/Modal';
import StyledButton from 'components/StyledButton';
import warningIcon from 'resources/images/warning.svg';

import useStyles from './styles';

type Props = {
    open: boolean,
    strings: object,
    onConfirm: () => {},
    onCancel: () => {}
};

function ConfirmQuitModal({ open, strings, onConfirm, onCancel }: Props) {
    const classes = useStyles();
    return (
        <Modal open={open}>
            <div className={classes.modalContainer}>
                <div className={classes.modalTitle}>
                    {strings.close_app_popup_title}
                </div>
                <div className={classes.modalDescription}>
                    <img
                        className={classes.warningIcon}
                        src={warningIcon}
                        alt="Info Icon"
                    />
                    {strings.close_app_popup_body}
                </div>
                <div className={classes.modalButtonContainer}>
                    <StyledButton
                        variant="outlined"
                        btnSize="small"
                        onClick={onConfirm}
                    >
                        {strings.close_app_popup_quit}
                    </StyledButton>
                    <StyledButton
                        styles={classes.cancelButton}
                        btnSize="small"
                        onClick={onCancel}
                    >
                        {strings.button_cancel}
                    </StyledButton>
                </div>
            </div>
        </Modal>
    );
}

export default ConfirmQuitModal;
